#Generate a batchfile to process all the available data

use strict;
use warnings;
use Cwd;
use Getopt::Long;

my $tooldir = "default_tool_dir";
my $pcper = 0;
my $perflab = 1;
my $sean = 0;
my $opt;

my %GA;

my $indir = "FCAT_IN";
my $outdir = "FCAT_OUT";
my $outbat = "run_fcat.bat";
my $debug;
my @tgames;
my @tgpus;
my @textra;

my $gui = 1;

# What phase should be run
my $extract = 0;
my $analyze = 1;
my $run = 0;

my $result = GetOptions ( "indir=s"    => \$indir,                        # input dir
			  "tooldir=s"  => \$tooldir,
			  "outdir=s"   => \$outdir,                       # output dir
			  "outbat=s"   => \$outbat,                       # Batfile name
			  "gpu=s"      => \@tgpus,                        # GPU name
			  "game=s"     => \@tgames,
			  "extra=s"    => \@textra,
                          "opt=s"      => \$opt,                          # extra doall options
			  "extract"    => \$extract,                      # Run extraction
			  "analyze"    => \$analyze,                      # Analyze
			  "pcp"        => \$pcper,                        # Do some funky parsing of dir names
			  "run"        => \$run,                          # Run the generated script
			  "debug"      => \$debug);                       # Turn on messages


if ($extract) {
    $analyze = 0;
}


# Make the output directory
unless (-d $outdir) {
    mkdir $outdir;
}

my $bf = "$outdir\\$outbat";
printf ("Creating Bat File : $bf\n");

unless (open BAT, ">$bf") {
    printf ("Unable to open BAT file\n");
    exit (1);
}

printf BAT ("echo off\n\n");

my %gpus;
my %games;
my %extra;

# Convert the arrays to hashi
foreach (@tgpus) {
    $gpus{$_} = 1;
}
foreach (@tgames) {
    $games{$_} = 1;
}
foreach (@textra) {
    $extra{$_} = 1;
}


opendir(IMD, $indir) || die ("Cannot open input directory : $indir\n");
my @gpus= readdir(IMD);

foreach my $gpu (@gpus) {
    unless ( ($gpu eq ".") or ($gpu eq "..") ) {
	
	# Open the GPU subdirs
	my $rundir = "$indir\\$gpu";
	
	# Find the real GPU name (if pcper)
	if ($sean) {
	    $gpu =~ /.*(AR.*|GTX.*|HD.*)/;
	    $gpu = $1;
	} elsif ($pcper) {
	    $gpu =~ /.*(AR.*|GTX.*|HD.*) \w+.*$/;
	    $gpu = $1;
	} 
	
	# Make sure the GPu is in the desired list
	next if ((($#tgpus+1)>0) and not exists $gpus{$gpu});
	
	printf ("GPU = $gpu\n");
	
	opendir(RD, $rundir) || die("Cannot open directory");
	my @runs= readdir(RD);
	close RD;
	my $game;
	
	foreach my $run (@runs) {
	    unless ( ($run eq ".") || ($run eq "..") || ($run =~ /full_res/i) || ($run =~ /313/i)) {
		
		my $fdir = $rundir . "\\" . $run;
		
		next unless -d $fdir;
		next if ((($#tgames+1)>0) and not exists $games{$run});
		
	        $game = $run;
		
		if ($pcper) {
		    $run =~ /^.*?_.*?_(.*)/;
		    if ($1) {
			$game = $1;
		    }
		} 
		
		
		if ($perflab) {
		    $run =~ /^.*?_(.*)\[/;
		    if ($1) {
			$game = $1;
		    }
		} 
		
		# Open each Games run
		opendir(GD, $fdir) || die("Cannot open directory");
		my @runlist= readdir(GD);
		close GD;
		
		my $found = 0;
		my $founde = 0;
		my $ms = "-";
		
		# Do some game name cleanup
		my $g = $game;
		if ($g =~ /Batman/) {
		    $g = "Batman";
		}
		if ($g =~ /BF3/) {
		    $g = "BF3";
		}
		if ($g =~ /Battle/) {
		    $g = "BF3";
		}
		if ($g =~ /Borderlands/) {
		    $g = "Borderlands2";
		}
		
		if ($g =~ /Metro/i) {
		    $g = "Metro2033";
		}
		
		if ($g =~ /Skyrim/) {
		    $g = "Skyrim";
		}
		
		if ($g =~ /F1/) {
		    $g = "F1 2012";
		}
		
		if ($g =~ /Crysis.*2/i) {
		    $g = "Crysis2";
		}
		
		if ($g =~ /Crysis.*3/i) {
		    $g = "Crysis3";
		}
	
		# Look for a directory level for extra runs
		foreach my $dg (@runlist) {
		    my $edir = $fdir . "\\" . $dg;

		    # Open up the directory if present
		    if (-d $edir){
			
			# filter
			next if ((($#textra+1)>0) and not exists $extra{$dg});
			next if (($dg eq ".") or ($dg eq ".."));
			printf ("     -> $g : Extra : $dg\n");

			opendir(ED, $edir) || die ("Cannot open directory");
			my @eruns= readdir(ED);
			close ED;
				
			# Look for MS file
			foreach my $dg1 (@eruns) {
			    if ($dg1 =~ /.*\.xls$/) {
				$found = $dg1;
				
				printf ("         -> $g : : HW Frametimes file : $dg1\n");
				
				#save the data
				$GA{$g}{$gpu}{$dg}{XLS} = "$edir\\$found";
			    }
			    
			    
			    if ($dg1 =~ /.*\.avi$/) {
				$founde = $dg1;
				printf ("         -> $g : : AVI file : $dg1\n");
				$GA{$game}{$gpu}{$dg}{AVI} = "$edir\\$founde";
			    }
			}

		    } else {
			
			if ($dg =~ /.*\.xls$/) {
			    $found = $dg;
			    
			    printf ("     -> $g : : HW Frametimes file : $dg\n");
			    
			    #save the data
			    $GA{$g}{$gpu}{""}{XLS} = "$fdir\\$found";
			}
			
			
			if ($dg =~ /.*\.avi$/) {
			    $founde = $dg;
			    printf ("     -> $g : : AVI file : $dg\n");
			    $GA{$game}{$gpu}{""}{AVI} = "$fdir\\$founde";
			}
		    }
		}
		
		if ($analyze and not $found) {
		    printf ("#  ERROR -> Missing HW Frametimes ($game, $gpu)\n");
		} 
		
		if ($extract and not $founde) {
		    printf ("#  ERROR -> Missing AVI file ($game, $gpu)\n");
		}
	    }
	}
    }
}


# generate the oput dirs and batch file
my $g;
my $gpu;
my $ex;

# Make output directories
foreach $g (sort keys %GA) {
    printf BAT ("echo.\necho ##### $g #####\n");
    printf BAT ("mkdir \"$g\"\n");;
    
    foreach $gpu (sort keys %{$GA{$g}}) {
	printf BAT ("mkdir \"$g\\$gpu\"\n");
	
	foreach $ex (sort keys %{$GA{$g}{$gpu}}) {
	    if ($ex) {
		printf BAT ("mkdir \"$g\\$gpu\\$ex\"\n");
	    }
	}
    }
}


# run extractor if requested
if ($extract) {
    foreach $g (sort keys %GA) {
	foreach $gpu (sort keys %{$GA{$g}}) {
	    foreach $ex (sort keys %{$GA{$g}{$gpu}}) {
		my $inp = $GA{$g}{$gpu}{$ex}{AVI};
		if ($inp) {	
		    printf BAT ("\necho Extracting...$inp\n");
		    printf BAT ( "$tooldir\\Extractor\\Extractor.exe -minimized");
		    printf BAT ("^\n                                -input \"$inp\" -output  \"$inp.xls\" ");
		}
	    }
	}
    }	

    printf BAT ("\n\n");
    
}


if ($analyze) {
    
    foreach $g (sort keys %GA) {
	
	printf BAT ("perl \"$tooldir\\Analysis\\fcat.pl\" --game \"$g\" --fps 0  --common \".\\$g\\PLOT\" --ymax \"\" $opt");
	foreach $gpu (sort keys %{$GA{$g}}) {
	    foreach $ex (sort keys %{$GA{$g}{$gpu}}) {
		my $inp = $GA{$g}{$gpu}{$ex}{XLS};
		printf BAT ("^\n                                --gpu \"$gpu\" --extra \"$ex\" --in \"$inp\" --out \".\\$g\\$gpu\\$ex\\run\"");
	    }
	}
	
	printf BAT ("\n\n");
	
	printf BAT ("perl \"$tooldir\\Analysis\\gen_percentiles.pl\" --game \"$g\" --common \".\\$g\\PER\"");
	foreach $gpu (sort keys %{$GA{$g}}) {
	    foreach $ex (sort keys %{$GA{$g}{$gpu}}) {
		my $inp = $GA{$g}{$gpu}{$ex}{XLS};
		printf BAT ("^\n                                --gpu \"$gpu\" --extra \"$ex\" --in \".\\$g\\$gpu\\$ex\\run.frametimes.csv\" -out \".\\$g\\$gpu\\$ex\\percentile\"");
	    }
	}
	printf BAT ("\n\n");

    }
    
    printf BAT ("echo.\necho ##### Summarizing #####\n");
    printf BAT ("perl \"$tooldir\\Analysis\\pivot.pl\"\n");
}

close (BAT);

# Run the generated batch file if directed
if ($run) {
    chdir $outdir;
    printf ("Running $outbat\n");
    system ($outbat);
}
